 	function k = LOCAL_MAX(x)
	
	% 	Used in design for vary flat linear-phase FIR filters
	%	FLAT_LP_FIR_1,  FLAT_LP_FIR_2, FLAT_BP_FIR_1,  FLAT_BP_FIR_2
	 
	% 	Finds location of local maxima
	
	% Author: Ivan W. Selesnick, Rice University
	
	s = size(x); x = [x(:)].'; 
	N = length(x);
	b1 = x(1:N-1)<=x(2:N); 
	b2 = x(1:N-1)>x(2:N);
	k = find(b1(1:N-2)&b2(2:N-1))+1;
	if x(1)>x(2), k = [k, 1]; end
	if x(N)>x(N-1), k = [k, N]; end
	k = sort(k); 
	if s(2) == 1, k = k'; end
	
